#ifndef _GLSL_PROGRAM_H_
#define _GLSL_PROGRAM_H_

#include <GL/glew.h>
#ifdef WIN32
#include <GL/wglew.h>
#endif

#ifdef __APPLE__
#include <GLUT/glut.h>
#else
#include <GL/glut.h>
#endif

#include <ErrorManager/ErrorManager.h>

#include <string>
#include <iostream>
#include <fstream>

class CGLSLProgram
{
public:
	enum SHADER_TYPE {
		VS_GS_FS,
		VS_GS,
		VS_FS,
		VS
	} shaderType;
private:
	bool isInstalled;

	GLhandleARB program, vs, gs, fs;
	std::string vs_path, gs_path, fs_path;

	GLint CheckShader(GLhandleARB object);
	void CompileShaderObject(std::string source, GLhandleARB object);
	std::string OpenShaderFile(std::string filename);

public:
	//avoid using this!
	GLhandleARB GetProgram();

	void SetUniform3f(const GLcharARB* name, const GLfloat v0, const GLfloat v1,const GLfloat v2);
	void SetUniform2f(const GLcharARB* name, const GLfloat v0, const GLfloat v1);
	void SetUniform1f(const GLcharARB* name, const GLfloat v0);
	void SetUniform1i(const GLcharARB* name, const GLint   v0);
	void SetTexture(const GLcharARB* name, const GLuint textureid, const GLint i);

	void InitVertexShader(const char *filen);
	void InitVertexShader(const char *filen, const char *defines);
	void InitGeometryShader(const char *filen, GLenum input, GLenum output, GLuint nPrimitivesOut);
	void InitGeometryShader(const char *filen, const char *defines, GLenum input, GLenum output, GLuint nPrimitivesOut);
	void InitFragmentShader(const char *filen);
	void InitFragmentShader(const char *filen, const char *defines);
	void LinkValidate();

	void Use();
	void Stop();

	CGLSLProgram(SHADER_TYPE st);
	~CGLSLProgram();
};

inline void GLstateTest(void) {
	GLenum error;
	do {
	error = glGetError();
	if(error != GL_NO_ERROR)
		std::cout << "Errors:"<<gluErrorString(error)<<"\n";
	} while (error != GL_NO_ERROR);
}

#endif //_GLSL_PROGRAM_H_
